﻿using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP.EFR.BO;

namespace VIRP_WEB.Custom.EFR
{
    public partial class Patients : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            ReplacePageTitle("Patients > Patient Lookup");

            if (!IsPostBack)
            {
                PanelSelectPatient.Visible = true;

                SetupCommonDataSourceParameters();
                LoadPreviousSearch();
            }

            if (!UserSession.IsRegistryAdministrator)
                GridViewEFRPatients.Columns[8].Visible = false;

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewEFRPatients.ClientID + "');", true);
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewNonEfrPatients.ClientID + "');", true);
        }

        private void LoadPreviousSearch()
        {
            bool previousSearchValid = false;

            string searchAll = SessionItemValue.Get(Session["Patient_Search_All"]);
            if (!string.IsNullOrEmpty(searchAll))
                previousSearchValid = true;
            else
            {
                string firstNameSearch = SessionItemValue.Get(Session["Patient_Search_First_Name"]);
                if (!string.IsNullOrEmpty(firstNameSearch))
                {
                    TextBoxPatientFirstNameSearch.Text = firstNameSearch;
                    previousSearchValid = true;
                }

                string lastNameSearch = SessionItemValue.Get(Session["Patient_Search_Last_Name"]);
                if (!string.IsNullOrEmpty(lastNameSearch))
                {
                    TextBoxPatientLastNameSearch.Text = lastNameSearch;
                    previousSearchValid = true;
                }

                string icn = SessionItemValue.Get(Session["Patient_Search_Icn"]);
                if (!string.IsNullOrEmpty(icn))
                {
                    TextBoxPatientICNSearch.Text = icn;
                    previousSearchValid = true;
                }
            }

            if (previousSearchValid)
                Search();
        }

        protected void ButtonSearchPatient_Click(object sender, EventArgs e)
        {
            Search();
        }

        private void SetupCommonDataSourceParameters()
        {
            var currentUser = HttpContext.Current.User.Identity.Name;
            ObjectDataSourcePatientsSearch.SelectParameters["CURRENT_USER"].DefaultValue = currentUser;
            ObjectDataSourceNonEfrPatientsSearch.SelectParameters["CURRENT_USER"].DefaultValue = currentUser;

            var currentRegistry = UserSession.CurrentRegistryId.ToString();
            ObjectDataSourcePatientsSearch.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = currentRegistry;
            ObjectDataSourceNonEfrPatientsSearch.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = currentRegistry;
        }

        private void Search()
        {
            if (HiddenFieldEfrPatients.Value == "false" && UserSession.IsRegistryAdministrator)
            {
                GridViewEFRPatients.Visible = false;

                GridViewNonEfrPatients.PageIndex = 0;
                GridViewNonEfrPatients.Visible = true;
                GridViewNonEfrPatients.DataBind();
            }
            else
            {
                GridViewNonEfrPatients.Visible = false;

                GridViewEFRPatients.PageIndex = 0;
                GridViewEFRPatients.Visible = true;
                GridViewEFRPatients.DataBind();
            }

            if (GridViewEFRPatients.Visible && GridViewEFRPatients.Rows.Count == 0
                && UserSession.IsRegistryAdministrator && HiddenFieldEfrPatients.Value == "true")
            {
                GridViewEFRPatients.Visible = false;

                string message = "No EFR patients matching your search criteria were found.  Would you like to search the Registries database?";
                ClientScript.RegisterStartupScript(typeof(Page), "Popup", "PopUpMessage('" + message + "');", true);
            }

            if (GridViewNonEfrPatients.Visible)
            {
                HiddenFieldEfrPatients.Value = "true";
            }

            SaveCurrentSearchFields();
        }

        private void SaveCurrentSearchFields()
        {
            if (SearchAllPatients())
                Session["Patient_Search_All"] = SessionItemFactory.Create("True");
            else
            {
                Session.Remove("Patient_Search_All");

                if (!string.IsNullOrEmpty(TextBoxPatientFirstNameSearch.Text))
                    Session["Patient_Search_First_Name"] = SessionItemFactory.Create(TextBoxPatientFirstNameSearch.Text);
                else
                    Session.Remove("Patient_Search_First_Name");

                if (!string.IsNullOrEmpty(TextBoxPatientLastNameSearch.Text))
                    Session["Patient_Search_Last_Name"] = SessionItemFactory.Create(TextBoxPatientLastNameSearch.Text);
                else
                    Session.Remove("Patient_Search_Last_Name");

                if (!string.IsNullOrEmpty(TextBoxPatientICNSearch.Text))
                    Session["Patient_Search_Icn"] = SessionItemFactory.Create(TextBoxPatientICNSearch.Text);
                else
                    Session.Remove("Patient_Search_Icn");
            }
        }

        private bool SearchAllPatients()
        {
            return string.IsNullOrEmpty(TextBoxPatientSSNSearch.Text)
                && string.IsNullOrEmpty(TextBoxPatientFirstNameSearch.Text)
                && string.IsNullOrEmpty(TextBoxPatientLastNameSearch.Text)
                && string.IsNullOrEmpty(TextBoxPatientICNSearch.Text);
        }

        public void Patients_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRPatients.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRPatients.SelectedValue);
                Response.Redirect(string.Format("Patient.aspx?patientId={0}", id), false);
            }
            else if (e.CommandName == "Workflows")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRPatients.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRPatients.SelectedValue);
                Response.Redirect(string.Format("PatientWorkflows.aspx?patientId={0}", id), false);
            }
            else if (e.CommandName == "Diagnostics")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRPatients.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRPatients.SelectedValue);
                Response.Redirect(string.Format("PatientRelatedDiagnoses.aspx?patientId={0}", id), false);
            }
            else if (e.CommandName == "LabTests")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRPatients.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRPatients.SelectedValue);
                Response.Redirect(string.Format("PatientRelatedLabTests.aspx?patientId={0}", id), false);
            }
            else if (e.CommandName == "Images")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRPatients.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRPatients.SelectedValue);
                Response.Redirect(string.Format("PatientImaging.aspx?patientId={0}", id), false);
            }
        }

        public void NonEfrPatients_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "AddReferral")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewNonEfrPatients.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewNonEfrPatients.SelectedValue);
                GridViewNonEfrPatients.SelectedIndex = -1;
                Response.Redirect(string.Format("~/Custom/EFR/Referrals/Referral.aspx?referralId=0&patientId={0}", id), false);
            }
        }

        protected string GetButtonToolTip(object count, string type)
        {
            int tryGetCount = Convert.ToInt32(count);
            string result = tryGetCount > 0 ? tryGetCount.ToString() : "no";
            return "There are " + result + " " + type + " for this patient.";
        }
    }
}